package gov.va.vinci.dart.json;


public class RoleAndGroupView implements Comparable {

	private int groupId = -1;
	private int roleId = -1;
	private String displayName = "";
	private int displayOrder = 0;
	
	
	public int getGroupId() {
		return groupId;
	}

	public void setGroupId(int groupId) {
		this.groupId = groupId;
	}

	public int getRoleId() {
		return roleId;
	}

	public void setRoleId(int roleId) {
		this.roleId = roleId;
	}

	public String getDisplayName() {
		return displayName;
	}

	public void setDisplayName(String displayName) {
		this.displayName = displayName;
	}

	public int getDisplayOrder() {
		return displayOrder;
	}

	public void setDisplayOrder(int displayOrder) {
		this.displayOrder = displayOrder;
	}
	
	
	@Override
	public int compareTo(Object o) {
		if (o == null) {
			return -1;
		}
		if (RoleAndGroupView.class.isAssignableFrom(o.getClass()) == false) {
			return -1;
		}
		
		RoleAndGroupView obj2 = (RoleAndGroupView)o;
		
		if( this.getDisplayOrder() == obj2.getDisplayOrder() ) {	//sort by display order
			
			if( this.getGroupId() == obj2.getGroupId() ) {	//sort by group
				return this.getRoleId() < obj2.getRoleId() ? -1 : 1;	//sort by role
			}

			return this.getGroupId() < obj2.getGroupId() ? -1 : 1;
			
		}//end if
		
		return this.getDisplayOrder() < obj2.getDisplayOrder() ? -1 : 1;
	}
	
}
